//=============================================================================
// MapEventBattle.js
//=============================================================================
var Imported = Imported || {};
Imported.MapEventBattle = true;

/*:
 * @plugindesc マップ上で行われる戦闘を補助するスクリプト
 * 
 * @help
 * beginMapEventBattle(eventID) で戦闘時に必要な変数を設定して、
 * endMapEventBattle(eventID) でそれらをクリアする。
 */

(function ()
{
    // 攻撃する方向の算出
    function getAttackDirection(source, destination)
    {
        var toward;

        var direction = {};

        var deltaX = source.deltaXFrom(destination.x);
        var deltaY = source.deltaYFrom(destination.y);

        if (Math.abs(deltaX) > Math.abs(deltaY))
        {
            if (deltaX > 0)
            {
                toward = 4;
            }
            else
            {
                toward = 6;
            }
        }
        else if (deltaY !== 0)
        {
            if (deltaY > 0)
            {
                toward = 8;
            }
            else
            {
                toward = 2;
            }
        }

        direction.first = toward;
        switch (source.direction())
        {
            case 8:
                switch (toward)
                {
                    case 8:
                        direction.second = 8;
                        break;

                    case 2:
                        direction.second = 2;
                        break;

                    case 4:
                        direction.second = 4;
                        break;

                    case 6:
                        direction.second = 6;
                        break;
                }
                break;

            case 2:
                switch (toward)
                {
                    case 8:
                        direction.second = 2;
                        break;

                    case 2:
                        direction.second = 8;
                        break;

                    case 4:
                        direction.second = 6;
                        break;

                    case 6:
                        direction.second = 4;
                        break;
                }
                break;

            case 4:
                switch (toward)
                {
                    case 8:
                        direction.second = 6;
                        break;

                    case 2:
                        direction.second = 4;
                        break;

                    case 4:
                        direction.second = 8;
                        break;

                    case 6:
                        direction.second = 2;
                        break;
                }
                break;

            case 6:
                switch (toward)
                {
                    case 8:
                        direction.second = 4;
                        break;

                    case 2:
                        direction.second = 6;
                        break;

                    case 4:
                        direction.second = 2;
                        break;

                    case 6:
                        direction.second = 8;
                        break;
                }
                break;
        }

        return direction;
    };

    // ダメージ計算
    function calcDamage(atk, def)
    {
        var avg;

        damage = (atk >> 1) - (def >> 2);
        if (damage < 0)
        {
            damage = 0;
        }
        else
        {
            avg = (damage >> 4) + 1;

            damage += Math.floor(Math.random() * (avg + 1 + avg)) - avg;
        }

        if (damage <= 0)
        {
            damage = Math.floor(Math.random() * 2);
        }

        return damage;
    };

    // クリティカル時のダメージ計算
    function calcCriticalDamage(atk)
    {
        var avg;

        damage = atk;
        if (damage < 0)
        {
            damage = 0;
        }
        else
        {
            avg = (damage >> 4) + 1;

            damage += Math.floor(Math.random() * (avg + 1 + avg)) - avg;
        }

        if (damage <= 0)
        {
            damage = Math.floor(Math.random() * 2);
        }

        return damage;
    };

    // 敵 HP の回復
    Game_Player.prototype.healEnemyHP = function (event)
    {
        event.hp = event.mhp;
    }

    Game_Player.prototype.PlaceAnimation = function (anim, x, y, mirror, delay)
    {
        var sprite = new Sprite_Base();
        var animId = anim || DG.Param.DefaultAnim;

        sprite.anim = $dataAnimations[animId];
        sprite.x = x || DG.Param.DefaultX;
        sprite.y = y || DG.Param.DefaultY;
        sprite.mirror = mirror || DG.Param.Mirror;
        sprite.delay = delay || DG.Param.AnimDelay;
        sprite.waitFor = DG.Param.WaitForComp;
        //How do I implement the use of Wait for Completion?

        sprite.dump = true;

        if (SceneManager._scene)
        {
            SceneManager._scene.addChild(sprite);
            sprite.startAnimation(sprite.anim, sprite.mirror, sprite.delay);
        }
    }

    // アニメーションフラグ
    Game_Player.prototype.setAnimationFlag = function (character, value)
    {
        character.canAnimation = value;
    }

    // アニメーションフラグ
    Game_Player.prototype.setForceEmpty = function (character, value)
    {
        character.forceEmpty = value;
    }

    // 攻撃アニメーション
    Game_Player.prototype.attackAnimation = function ()
    {
        var actor = $gameActors._data[1];

        var animationNo;

        if (actor.hasNoWeapons())
        {
            animationNo = 121;
        }
        else
        {
            animationNo = 123;
        }

        var playerScreenX = $gamePlayer.screenX();
        var playerScreenY = $gamePlayer.screenY() - 24;

        var enemyX = $gamePlayer._x;
        var enemyY = $gamePlayer._y;

        var mirror = 0;

        var playerDirection = $gamePlayer.direction();

        switch (playerDirection)
        {
            case 8:
                playerScreenY -= 48;

                enemyY -= 1;
                break;

            case 2:
                playerScreenY += 48;

                enemyY += 1;
                break;

            case 4:
                playerScreenX -= 48;

                enemyX -= 1;
                break;

            case 6:
                playerScreenX += 48;
                mirror = 1;

                enemyX += 1;
                break;
        }

        // Game_Event を取得する
        var event = $gameMap.eventsXy(enemyX, enemyY).filter(function (event)
        {
            return event.enemyID != null;
        })[0];

        // ターン計算
        var turn = (2000 - (actor.agi * 12));
        if (turn < 500)
        {
            turn = 500;
        }
        $gamePlayer.turn = Math.ceil(turn / 17);

        if (event == null)
        {
            // 敵が前方にいない
            this.PlaceAnimation(animationNo, playerScreenX, playerScreenY, mirror, 0);

            return;
        }
        else
        {
            if (event.forceEmpty != null && event.forceEmpty)
            {
                this.PlaceAnimation(animationNo, playerScreenX, playerScreenY, mirror, 0);

                return;
            }
            else if (event.hp != null && event.hp <= 0)
            {
                var canAnimation = true;
                if (event != null)
                {
                    if (event.canAnimation != null)
                    {
                        canAnimation = event.canAnimation;
                    }
                }

                if (canAnimation)
                {
                    // 敵が前方にいない
                    this.PlaceAnimation(animationNo, playerScreenX, playerScreenY, mirror, 0);
                }

                return;
            }
        }

        // Game_Enemy を取得する
        var enemy = $dataEnemies[event.enemyID];

        $gameVariables.setValue(49, -1);

        if (!event.mhp)
        {
            event.mhp = event.hp = enemy.params[0];

            event.atk = enemy.params[2];
            event.def = enemy.params[3];
            event.luk = enemy.params[7];

            event.canAnimation = true;
            event.forceEmpty = false;
        }

        // プレイヤと向かい合っているかどうか
        var isEnemyOpposite;

        var enemyDirection = event.direction();

        switch (playerDirection)
        {
            case 8:
                if (enemyDirection == 2)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 2:
                if (enemyDirection == 8)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 4:
                if (enemyDirection == 6)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 6:
                if (enemyDirection == 4)
                {
                    isEnemyOpposite = true;
                }
                break;
        }

        // ダメージ計算
        var attackDirection = { first: null, second: null };
        var atk, def, damage;
        var criticalRate;
        var isCritical;
        var hasEnemyDefeated = event.hp <= 0;

        attackDirection = getAttackDirection(event, $gamePlayer);

        atk = actor.atk;
        def = event.def;

        if (attackDirection == 2)
        {
            criticalRate = 0.0625;
        }
        else
        {
            criticalRate = 0.03125;
        }

        if (Math.random() < criticalRate)
        {
            isCritical = true;

            damage = calcCriticalDamage(atk);
        }
        else
        {
            damage = calcDamage(atk, def);
        }

        $gameSwitches.setValue(02, false);

        event.hp -= damage;
        if (event.hp <= 0)
        {
            hasEnemyDefeated = true;

            event.hp = 0;

            event.setPosition(event._x, event._y);
            event.lock();

            var lastLevel = actor.level;

            actor.changeExp(actor.currentExp() + enemy.exp, false);
            if (actor.level > lastLevel)
            {
                $gameSwitches.setValue(02, true);
            }
        }

        event.popupDamage(damage, isCritical);

        if (actor.hasNoWeapons())
        {
            if (damage <= 0)
            {
                animationNo = 128;
            }
            else
            {
                if (isCritical)
                {
                    animationNo = 122;
                }
                else
                {
                    animationNo = 121;
                }
            }
        }
        else
        {
            if (damage <= 0)
            {
                animationNo = 129;
            }
            else
            {
                if (isCritical)
                {
                    animationNo = 124;
                }
                else
                {
                    animationNo = 123;
                }
            }
        }

        this.PlaceAnimation(animationNo, playerScreenX, playerScreenY, mirror, 0);

        $gameSwitches.setValue(26, hasEnemyDefeated);

        if (enemy.dropItems[0].kind != 0)
        {
            $gameVariables.setValue(46, Math.floor((1 / enemy.dropItems[0].denominator) * 10000));
        }
        else
        {
            $gameVariables.setValue(46, 0);
        }

        $gameSelfSwitches.setValue([$gameMap.mapId(), event._eventId, "A"], true);
    }
/*
    // 戦闘開始
    Game_Player.prototype.beginMapEventBattle = function (enemyID, event)
    {
        var actor = $gameActors._data[1];

        // Game_Enemy を取得する
        var enemy = $dataEnemies[enemyID];

        $gameVariables.setValue(49, -1);

        if (!event.mhp)
        {
            event.mhp = event.hp = enemy.params[0];

            event.atk = enemy.params[2];
            event.def = enemy.params[3];
            event.luk = enemy.params[7];
        }

        var canEnemyAttack = true;

        // 攻撃しない敵
        if (!!enemy.meta.attack)
        {
            canEnemyAttack = !(enemy.meta.attack == "false");
        }

        // 敵の攻撃待機
        if ($gameSwitches.value(28))
        {
            canEnemyAttack = false;
        }

        // ダメージ計算
        var atk, def, damage;
        var criticalRate;
        var isCritical;

        var attackDirection = { first: null, second: null };

        if (canEnemyAttack)
        {
            attackDirection = getAttackDirection($gamePlayer, event);

            atk = event.atk;
            def = actor.def;

            criticalRate = 0.0;
            if (!!enemy.meta.criticalRate)
            {
                criticalRate = parseFloat(enemy.meta.criticalRate);
            }

            if (Math.random() < criticalRate)
            {
                isCritical = true;

                damage = $gamePlayer.damage = calcCriticalDamage(atk);
            }
            else
            {
                damage = $gamePlayer.damage = calcDamage(atk, def);
            }

            if (actor.isStateAffected(14))
            {
                damage = $gamePlayer.damage = 0;
            }

            $gameVariables.setValue(49, enemyID);

            actor.gainHp(-damage);
        }

        $gameVariables.setValue(61, attackDirection.first);
        $gameVariables.setValue(62, attackDirection.second);

        $gameSwitches.setValue(27, canEnemyAttack);

        $gameSwitches.setValue(22, isCritical);

        $gameVariables.setValue(63, damage);
    };
*/
    // 戦闘開始
    Game_Player.prototype.beginMapEventBattle = function (enemyID, eventID)
    {
        // Game_Enemy を取得する
        var enemy = $dataEnemies[enemyID];

        $gameVariables.setValue(49, -1);

        // Game_Event を取得する
        var event = $gameMap.eventsXy($gameVariables.value(41), $gameVariables.value(42)).filter(function (event)
        {
            return event._dataEventId === eventID;
        })[0];

        var nowDate;

        nowDate = Date.now();
        if (!event.mhp)
        {
            event.mhp = event.hp = enemy.params[0];

            event.atk = enemy.params[2];
            event.def = enemy.params[3];
            event.luk = enemy.params[7];

            event.lastDate = nowDate - 1000;
        }

        // プレイヤの前に敵がいるかどうか
        var isEnemyFront, isEnemyOpposite;

        var playerDirection = $gamePlayer.direction();
        var enemyDirection = event.direction();

        switch (playerDirection)
        {
            case 8:
                isEnemyFront = $gamePlayer.pos(event.x, event.y + 1);

                if (enemyDirection == 2)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 2:
                isEnemyFront = $gamePlayer.pos(event.x, event.y - 1);

                if (enemyDirection == 8)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 4:
                isEnemyFront = $gamePlayer.pos(event.x + 1, event.y);

                if (enemyDirection == 6)
                {
                    isEnemyOpposite = true;
                }
                break;

            case 6:
                isEnemyFront = $gamePlayer.pos(event.x - 1, event.y);

                if (enemyDirection == 4)
                {
                    isEnemyOpposite = true;
                }
                break;
        }

        // それぞれの向き
        var actor = $gameActors._data[1];

        var attackDirection = { first: null, second: null };

        var canPlayerAttack = true;

        if (isEnemyFront)
        {
            if (isEnemyOpposite)
            {
                canPlayerAttack = $gamePlayer.getInputDirection() > 0;

                var frontDEX = 0.0;
                if (!!enemy.meta.frontDEX)
                {
                    frontDEX = parseFloat(enemy.meta.frontDEX);
                }

                if (Math.random() < frontDEX)
                {
                    canPlayerAttack = false;
                }

                if (actor.isStateAffected(15))
                {
                    canPlayerAttack = true;
                }
            }
        }
        else
        {
            canPlayerAttack = false;
        }

        // プレイヤのターンが貯まっているかどうか
        var lastDate, pastDate, turn;

        lastDate = $gamePlayer.lastDate;
        if (!lastDate)
        {
            lastDate = 0;
        }
        pastDate = nowDate - lastDate;

        turn = (2000 - (actor.agi * 12));
        if (turn < 500)
        {
            turn = 500;
        }

        if (pastDate < turn)
        {
            canPlayerAttack = false;
        }
/*
        // 攻撃ボタンオフ
        if (!$gameSwitches.value(33))
        {
            canPlayerAttack = false;
        }

        // 空振りアニメーション
        if ($gameSwitches.value(34))
        {
            canPlayerAttack = false;
        }
*/
        // 同じ敵には 0.5秒 待たないと攻撃できない
        lastDate = event.lastDate;
        pastDate = nowDate - lastDate;

        if (pastDate < 500)
        {
            canPlayerAttack = false;
        }

        var canEnemyAttack = true;

        // 攻撃しない敵
        if (!!enemy.meta.attack)
        {
            canEnemyAttack = !(enemy.meta.attack == "false");
        }

        // 敵の攻撃待機
        if ($gameSwitches.value(28))
        {
            canEnemyAttack = false;
        }

        // ダメージ計算
        var atk, def, damage;
        var criticalRate;
        var isCritical;
        var hasEnemyDefeated = event.hp <= 0;

        if (canPlayerAttack)
        {
            $gamePlayer.lastDate = nowDate;
            event.lastDate = nowDate;

            attackDirection = getAttackDirection(event, $gamePlayer);

            atk = actor.atk;
            def = event.def;

            if (attackDirection == 2)
            {
                criticalRate = 0.0625;
            }
            else
            {
                criticalRate = 0.03125;
            }

            if (Math.random() < criticalRate)
            {
                isCritical = true;

                damage = calcCriticalDamage(atk);
            }
            else
            {
                damage = calcDamage(atk, def);
            }

            event.hp -= damage;
            if (event.hp <= 0)
            {
                hasEnemyDefeated = true;

                event.hp = 0;

                event.setPosition(event._x, event._y);
                event.lock();

                var lastLevel = actor.level;

                actor.changeExp(actor.currentExp() + enemy.exp, false);
                if (actor.level > lastLevel)
                {
                    $gameSwitches.setValue(02, true);
                }
            }

            event.popupDamage(damage, isCritical);
        }
        else if (canEnemyAttack)
        {
            event.lastDate = nowDate;

            attackDirection = getAttackDirection($gamePlayer, event);

            atk = event.atk;
            def = actor.def;

            criticalRate = 0.0;
            if (!!enemy.meta.criticalRate)
            {
                criticalRate = parseFloat(enemy.meta.criticalRate);
            }

            if (Math.random() < criticalRate)
            {
                isCritical = true;

                damage = $gamePlayer.damage = calcCriticalDamage(atk);
            }
            else
            {
                damage = $gamePlayer.damage = calcDamage(atk, def);
            }

            if (actor.isStateAffected(14))
            {
                damage = $gamePlayer.damage = 0;
            }

            $gameVariables.setValue(49, enemyID);

            actor.gainHp(-damage);
        }

        $gameSwitches.setValue(21, canPlayerAttack);
        $gameSwitches.setValue(27, canEnemyAttack);

        $gameSwitches.setValue(22, isCritical);
        $gameSwitches.setValue(25, actor.hasNoWeapons());
        $gameSwitches.setValue(26, hasEnemyDefeated);

        $gameVariables.setValue(61, attackDirection.first);
        $gameVariables.setValue(62, attackDirection.second);

        $gameVariables.setValue(63, damage);

        if (enemy.dropItems[0].kind != 0)
        {
            $gameVariables.setValue(46, Math.floor((1 / enemy.dropItems[0].denominator) * 10000));
        }
        else
        {
            $gameVariables.setValue(46, 0);
        }

        //console.error(actor.atk, actor.def, actor.mhp);
    };

    // 戦闘終了
    Game_Player.prototype.endMapEventBattle = function ()
    {
        $gameSwitches.setValue(02, false);

        $gameSwitches.setValue(26, false);
    };

    // ドロップ アイテムの取得
    Game_Player.prototype.getDropItem = function (enemyID)
    {
        var enemy = $dataEnemies[enemyID];

        $gameVariables.setValue(45, enemy.dropItems[0].dataId);

        $gameParty.gainItem($dataItems[$gameVariables.value(45)], 1);
    }

    // ダメージ ポップ アップ関数を呼び出す
    Game_Player.prototype.callPopupDamage = function ()
    {
        this.popupDamage(this.damage, false);
    };
}());
